/*
 * Copyright (c) 2012 Torsten Hoefler. All rights reserved.
 *
 * Author(s): Torsten Hoefler <htor@illinois.edu>
 *
 */

#include <stdio.h>
#include <stdlib.h>
#include "MersenneTwister.h"

typedef struct{
  int value;
  int next;
} t_elem;

typedef struct {
  t_elem *table; // the table + heap
  int *last; // direct link to last element -- avoid traversing list!
  int nextfree; // the next free item in heap
  int size; // size of the heap
  int tsize; // size of table
} t_hash;

int hashfunc(int val) {
  return val & 65535;
}

int insert(t_hash *hash, int elem) {

  //printf("insert %i\n", elem);
  int pos = hashfunc(elem);
  if(hash->table[pos].value == -1) {
    hash->table[pos].value = elem;
  } else {
    //printf("collision %i %i (%i)\n", hash->table[pos].value, elem, hashfunc(elem));
    // check heap and go if necessary
    int newelem=hash->nextfree++;
    //printf("allocated %i\n", hash->nextfree-65536);
    if(hash->table[pos].next == -1) {
      // link new elem from table
      hash->table[pos].next = newelem;
    } else {
      int newpos=hash->last[pos];
      hash->table[newpos].next = newelem;
    }
    hash->last[pos]=newelem;
    // fill allocated element
    hash->table[newelem].value = elem;
  }
}

int count(t_hash *hash) {

  int cnt=0;
  int heapcnt=0;
  for(int i=0; i<hash->tsize; ++i) {
    int pos = i;
    if(hash->table[pos].value != -1) {
      cnt++;
      if(hash->table[pos].next != -1) {
        heapcnt++;
        pos=hash->table[pos].next;
        while(hash->table[pos].next != -1) {
          pos = hash->table[pos].next;
          heapcnt++;
        }
      }
    }
  }
  printf("cnt: %i heapcnt: %i, total: %i\n", cnt, heapcnt, cnt+heapcnt);
  return cnt+heapcnt;
}


int main(int argc, char **argv) {

  int n = atoi(argv[1]); // number of total entries, will fill 1/2

  t_hash hash;

  hash.tsize = 65536;
  hash.table = (t_elem*)calloc(1,(hash.tsize+n)*sizeof(t_elem)); // the actual table
  hash.last = (int*)calloc(1,hash.tsize*sizeof(int));
  hash.nextfree = hash.tsize;
  hash.size = n;

  MTRand mt(999);

  // initialize table
  for(int i=0; i<hash.tsize+n; ++i) {
    if(i<hash.tsize) hash.last[i]=-1;
    hash.table[i].next=-1;
    hash.table[i].value=-1;
  }

  for(int i=0; i<n; ++i) {
    insert(&hash, abs(mt.randInt())); // positive
  }

  count(&hash);

}
